/* © 2024 Appstock */

import AppstockSDK
import IronSource

class IronSourceBannerVideoRewardedViewController: InterstitialBaseViewController {

    private var isRewardedShown = false
    
    override func viewDidLoad() {
        super.viewDidLoad()

        loadAd()
    }
    
    private func loadAd() {
        // 1. Inititalize ironSource SDK
        IronSource.initWithAppKey("2277baa3d", adUnits: [IS_REWARDED_VIDEO])
        
        // 2. Set rewarded delegate
        IronSource.setLevelPlayRewardedVideoDelegate(self)
    }
}

extension IronSourceBannerVideoRewardedViewController: LevelPlayRewardedVideoDelegate {
    
    func hasAvailableAd(with adInfo: ISAdInfo!) {
        // 3. Check if rewarded ad is available
        if IronSource.hasRewardedVideo() && !isRewardedShown {
            // 4. Show the ad
            IronSource.showRewardedVideo(with: self)
            isRewardedShown = true
        }
    }
    
    func hasNoAvailableAd() {
        print("No available ads")
    }
    
    func didFailToShowWithError(_ error: (any Error)!, andAdInfo adInfo: ISAdInfo!) {
        print("Did fail to show ad with error: \(error.localizedDescription)")
    }
 
    func didReceiveReward(forPlacement placementInfo: ISPlacementInfo!, with adInfo: ISAdInfo!) {
        print("Did recieve reward")
    }
    
    func didOpen(with adInfo: ISAdInfo!) {}
    func didClick(_ placementInfo: ISPlacementInfo!, with adInfo: ISAdInfo!) {}
    func didClose(with adInfo: ISAdInfo!) {}
}
