/* © 2024 Appstock */

#import "AdMobBannerRewardedViewController.h"

@interface AdMobBannerRewardedViewController ()

@property (nonatomic) GADRewardedAd * rewardedAd;

@end

@implementation AdMobBannerRewardedViewController

- (NSString *)adUnitId {
    return @"ca-app-pub-2844566227051243/2051572630";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Load the rewarded ad
    __weak typeof(self) weakSelf = self;
    [GADRewardedAd loadWithAdUnitID:self.adUnitId
                            request:[GADRequest new]
                  completionHandler:^(GADRewardedAd * _Nullable rewardedAd,
                                      NSError * _Nullable error) {
        if (error != nil || rewardedAd == nil) {
            return;
        }
        
        weakSelf.rewardedAd = rewardedAd;
        
        // 2. Configure the rewarded ad
        weakSelf.rewardedAd.fullScreenContentDelegate = self;
        
        // 3. Present the rewarded ad
        [weakSelf.rewardedAd presentFromRootViewController:self
                                  userDidEarnRewardHandler:^{
            NSLog(@"User did earn reward.");
        }];
    }];
}

// MARK: - GADFullScreenContentDelegate

- (void)ad:(id<GADFullScreenPresentingAd>)ad didFailToPresentFullScreenContentWithError:(NSError *)error {
    NSLog(@"Did fail to receive ad with error: %@", error.localizedDescription);
}

@end
