/* © 2024 Appstock */

#import "AppLovinBannerRewardedViewController.h"

@interface AppLovinBannerRewardedViewController ()

@property (nonatomic) MARewardedAd * rewardedAd;

@end

@implementation AppLovinBannerRewardedViewController

- (NSString *)adUnitId {
    return @"<AD_UNIT_ID>";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Create a MARewardedAd
    self.rewardedAd = [MARewardedAd sharedWithAdUnitIdentifier:self.adUnitId];
    
    // 2. Configure the MARewardedAd
    self.rewardedAd.delegate = self;
    
    // 3. Load the ad
    [self.rewardedAd loadAd];
}

// MARK: - MAAdDelegate

- (void)didLoadAd:(MAAd *)ad {
    if (self.rewardedAd != nil && self.rewardedAd.isReady) {
        [self.rewardedAd showAd];
    }
}

- (void)didFailToLoadAdForAdUnitIdentifier:(NSString *)adUnitIdentifier withError:(MAError *)error {
    NSLog(@"Did fail to load ad with error: %@", error.message);
}

- (void)didFailToDisplayAd:(MAAd *)ad withError:(MAError *)error {
    NSLog(@"Did fail to display ad with error: %@", error.message);
}

- (void)didRewardUserForAd:(MAAd *)ad withReward:(MAReward *)reward {
    NSLog(@"User did earn reward - label: %@, amount: %ld", reward.label, reward.amount);
}

- (void)didDisplayAd:(MAAd *)ad {}
- (void)didHideAd:(MAAd *)ad {}
- (void)didClickAd:(MAAd *)ad {}

@end
