/* © 2024 Appstock */

#import "TopOnBannerAdViewController.h"

@implementation TopOnBannerAdViewController

- (NSString *)placementID {
    return @"n66daf48287b5e";
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Setup ad
    NSDictionary *extra = @{
        kATAdLoadingExtraBannerAdSizeKey: [NSValue valueWithCGSize:CGSizeMake(300, 250)]
    };

    // 2. Load the ad
    [[ATAdManager sharedManager] loadADWithPlacementID:self.placementID
                                                 extra:extra
                                              delegate:self];
}

// MARK: - ATAdLoadingDelegate

- (void)didFinishLoadingADWithPlacementID:(NSString *)placementID {
    // 3. Check if banner is ready
    if ([[ATAdManager sharedManager] bannerAdReadyForPlacementID:placementID]) {
        NSInteger tag = 3333;
        UIView *existingView = [self.view viewWithTag:tag];
        [existingView removeFromSuperview];
        
        // 4. Retrieve banner view
        UIView *bannerView = [[ATAdManager sharedManager] retrieveBannerViewForPlacementID:placementID];
        if (bannerView) {
            // 5. Add GMA SDK banner view to the app UI
            [self.containerAdView addSubview:bannerView];
        }
    }
}

- (void)didFailToLoadADWithPlacementID:(NSString *)placementID error:(NSError *)error {
    NSLog(@"Did fail to load ad: %@", error.localizedDescription);
}

- (void)didFailBiddingADSourceWithPlacementID:(NSString *)placementID
                                        extra:(NSDictionary *)extra
                                        error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didFailToLoadADSourceWithPlacementID:(NSString *)placementID
                                       extra:(NSDictionary *)extra
                                       error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didRevenueForPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didStartLoadingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didFinishLoadingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didStartBiddingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didFinishBiddingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}

@end
