/* © 2024 Appstock */

#import "TopOnNativeViewController.h"

@implementation TopOnNativeViewController

+ (NSString *)nib {
    return @"TopOnNativeViewController";
}

- (NSString *)placementID {
    return @"n66daf48383710";
}

- (instancetype)init {
    self = [super initWithNibName:TopOnNativeViewController.nib bundle:nil];
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self loadAd];
}

- (void)loadAd {
    // 1. Configure the native parameters
    
    AppstockNativeAssetImage *image = [
        [AppstockNativeAssetImage alloc]
        initWithMinimumWidth:200
        minimumHeight:200
        required:true
    ];
    
    image.type = AppstockImageAsset.Main;
    
    AppstockNativeAssetImage *icon = [
        [AppstockNativeAssetImage alloc]
        initWithMinimumWidth:20
        minimumHeight:20
        required:true
    ];
    
    icon.type = AppstockImageAsset.Icon;
    
    AppstockNativeAssetTitle *title = [
        [AppstockNativeAssetTitle alloc]
        initWithLength:90
        required:true
    ];
    
    AppstockNativeAssetData *body = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetDescription
        required:true
    ];
    
    AppstockNativeAssetData *cta = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetCtatext
        required:true
    ];
    
    AppstockNativeAssetData *sponsored = [
        [AppstockNativeAssetData alloc]
        initWithType:AppstockDataAssetSponsored
        required:true
    ];
    
    AppstockNativeParameters * parameters = [AppstockNativeParameters new];
    parameters.assets = @[title, icon, image, sponsored, body, cta];
    
    AppstockNativeEventTracker * eventTracker = [
        [AppstockNativeEventTracker alloc]
        initWithEvent:AppstockEventType.Impression
        methods:@[AppstockEventTracking.Image, AppstockEventTracking.js]
    ];
    
    parameters.eventtrackers = @[eventTracker];
    parameters.context = AppstockContextType.Social;
    parameters.placementType = AppstockPlacementType.FeedContent;
    parameters.contextSubType = AppstockContextSubType.Social;
    
    // 2. Set up the extras
    NSDictionary *extra = @{
        kAppstockNativeAssets : parameters
    };
    
    // 3. Load the ad
    [[ATAdManager sharedManager] loadADWithPlacementID:self.placementID
                                                 extra:extra
                                              delegate:self];
}

// MARK: - ATAdLoadingDelegate

- (void)didFinishLoadingADWithPlacementID:(NSString *)placementID {
    // 4. Get the offer
    ATNativeAdOffer *offer = [[ATAdManager sharedManager] getNativeAdOfferWithPlacementID:placementID];
    if (!offer) {
        return;
    }
    
    // 5. Create a config
    ATNativeADConfiguration *config = [[ATNativeADConfiguration alloc] init];
    
    // 6. Create a ATNativeADView
    ATNativeADView *nativeADView = [[ATNativeADView alloc] initWithConfiguration:config
                                                                    currentOffer:offer
                                                                     placementID:placementID];
    
    nativeADView.delegate = self;
    
    // 7. Register clickable views
    [nativeADView registerClickableViewArray:@[self.callToActionLabel,
                                               self.mainImageView, self.iconView]];
    
    // 8. Bind the views
    ATNativePrepareInfo *info = [ATNativePrepareInfo loadPrepareInfo:^(ATNativePrepareInfo * _Nonnull info) {
        info.titleLabel = self.titleLabel ?: [[UILabel alloc] init];
        info.advertiserLabel = self.sponsoredLabel ?: [[UILabel alloc] init];
        info.textLabel = self.bodyLabel ?: [[UILabel alloc] init];
        info.ctaLabel = self.callToActionLabel ?: [[UILabel alloc] init];
        info.mainImageView = self.mainImageView ?: [[UIImageView alloc] init];
        info.iconImageView = self.iconView ?: [[UIImageView alloc] init];
    }];

    [nativeADView prepareWithNativePrepareInfo:info];
    
    // 9. Call renderer
    [offer rendererWithConfiguration:config
                      selfRenderView:nil
                       nativeADView:nativeADView];

    [self.view addSubview:nativeADView];
}

- (void)didFailToLoadADWithPlacementID:(NSString *)placementID error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didFailBiddingADSourceWithPlacementID:(NSString *)placementID
                                        extra:(NSDictionary *)extra
                                        error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didFailToLoadADSourceWithPlacementID:(NSString *)placementID
                                       extra:(NSDictionary *)extra
                                       error:(NSError *)error {
    NSLog(@"Did fail to load ad source: %@", error.localizedDescription);
}

- (void)didRevenueForPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didStartLoadingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didFinishLoadingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didStartBiddingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}
- (void)didFinishBiddingADSourceWithPlacementID:(NSString *)placementID extra:(NSDictionary *)extra {}

// MARK: - ATNativeADDelegate

- (void)didShowNativeAdInAdView:(ATNativeADView *)adView
                    placementID:(NSString *)placementID
                          extra:(NSDictionary *)extra {}

- (void)didClickNativeAdInAdView:(ATNativeADView *)adView
                     placementID:(NSString *)placementID
                           extra:(NSDictionary *)extra {}
@end
