/* © 2024 Appstock */

#import "IronSourceBannerVideoAdViewController.h"

@interface IronSourceBannerVideoAdViewController ()

@property (nonatomic, nullable) LPMBannerAdView * bannerView;

@end

@implementation IronSourceBannerVideoAdViewController

- (NSString *)adUnitId {
	return @"lm4bvvi8vs39gyad";
}

- (void)viewDidLoad {
	[super viewDidLoad];
	
	[self loadAd];
}

- (void)loadAd {
	// 1. Create LPMBannerAdViewConfig
	LPMAdSize * size = [LPMAdSize customSizeWithWidth:300 height:250];
	LPMBannerAdViewConfig * adConfig = [[[[LPMBannerAdViewConfigBuilder alloc] init] setWithAdSize:size] build];
	
	// 2. Create LPMBannerAdView
	LPMBannerAdView * bannerView = [[LPMBannerAdView alloc] initWithAdUnitId:self.adUnitId config:adConfig];
	bannerView.frame = CGRectMake(0, 0, size.width, size.height);
	
	// 3. Store instance of LPMBannerAdView
	self.bannerView = bannerView;
	
	// 4. Add ironSource SDK banner view to the app UI
	[self.containerAdView addSubview:bannerView];
	
	// 5. Set delegate
	[bannerView setDelegate:self];
	
	// 6. Load the ad
	[bannerView loadAdWithViewController:self];
}

// MARK: - LPMBannerAdViewDelegate

- (void)didFailToLoadAdWithAdUnitId:(NSString *)adUnitId error:(NSError *)error {
	NSLog(@"Did fail to load the ad: %@", error.localizedDescription);
}

- (void)didFailToDisplayAdWithAdInfo:(LPMAdInfo *)adInfo error:(NSError *)error {
	NSLog(@"Did fail to display the ad: %@", error.localizedDescription);
}

- (void)didLoadAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didClickAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didLeaveAppWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didExpandAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didCollapseAdWithAdInfo:(LPMAdInfo *)adInfo {}

@end
