/* © 2024 Appstock */

#import "IronSourceBannerVideoInterstitialViewController.h"

@interface IronSourceBannerVideoInterstitialViewController ()

@property(nonatomic, nullable) LPMInterstitialAd * interstitialAd;

@end

@implementation IronSourceBannerVideoInterstitialViewController

- (NSString *)adUnitId {
	return @"nthv9kz3dlew119l";
}

- (void)viewDidLoad {
	[super viewDidLoad];
	
	[self loadAd];
}

- (void)loadAd {
	// 1. Create LPMInterstitialAd
	LPMInterstitialAd * interstitialAd = [[LPMInterstitialAd alloc] initWithAdUnitId:self.adUnitId];
	
	// 2. Store interstitialAd instance
	self.interstitialAd = interstitialAd;
	
	// 3. Set delegate
	[interstitialAd setDelegate:self];
	
	// 4. Load the ad
	[interstitialAd loadAd];
}

// MARK: - LPMInterstitialAdDelegate

- (void)didLoadAdWithAdInfo:(LPMAdInfo *)adInfo {
	// 5. Check if interstitial ad is available
	if (self.interstitialAd && self.interstitialAd.isAdReady == YES) {
		// 5. Show the ad
		[self.interstitialAd showAdWithViewController:self placementName:nil];
	}
}

- (void)didFailToLoadAdWithAdUnitId:(NSString *)adUnitId error:(NSError *)error {
	NSLog(@"Did fail to load the ad: %@", error.localizedDescription);
}

- (void)didFailToDisplayAdWithAdInfo:(LPMAdInfo *)adInfo error:(NSError *)error {
	NSLog(@"Did fail to display the ad: %@", error.localizedDescription);
}

- (void)didDisplayAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didClickAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didCloseAdWithAdInfo:(LPMAdInfo *)adInfo {}

@end
