/* © 2024 Appstock */

#import "IronSourceBannerVideoRewardedViewController.h"

@interface IronSourceBannerVideoRewardedViewController ()

@property(nonatomic, nullable) LPMRewardedAd * rewardedAd;

@end

@implementation IronSourceBannerVideoRewardedViewController

- (NSString *)adUnitId {
	return @"yazrjdrk2jx6p030";
}

- (void)viewDidLoad {
	[super viewDidLoad];
	
	[self loadAd];
}

- (void)loadAd {
	// 1. Create LPMRewardedAd
	LPMRewardedAd * rewardedAd = [[LPMRewardedAd alloc] initWithAdUnitId:self.adUnitId];
	
	// 2. Store LPMRewardedAd instance
	self.rewardedAd = rewardedAd;
	
	// 3. Set delegate
	[rewardedAd setDelegate:self];
	
	// 4. Load the ad
	[rewardedAd loadAd];
}

// MARK: - LPMRewardedAdDelegate

- (void)didLoadAdWithAdInfo:(LPMAdInfo *)adInfo {
	// 5. Check if rewarded ad is available
	if (self.rewardedAd && self.rewardedAd.isAdReady == YES) {
		// 5. Show the ad
		[self.rewardedAd showAdWithViewController:self placementName:nil];
	}
}

- (void)didFailToLoadAdWithAdUnitId:(NSString *)adUnitId error:(NSError *)error {
	NSLog(@"Did fail to load the ad: %@", error.localizedDescription);
}

- (void)didFailToDisplayAdWithAdInfo:(LPMAdInfo *)adInfo error:(NSError *)error {
	NSLog(@"Did fail to display the ad: %@", error.localizedDescription);
}

- (void)didRewardAdWithAdInfo:(LPMAdInfo *)adInfo reward:(LPMReward *)reward {
	NSLog(@"Did recieve reward");
}

- (void)didDisplayAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didClickAdWithAdInfo:(LPMAdInfo *)adInfo {}
- (void)didCloseAdWithAdInfo:(LPMAdInfo *)adInfo {}

@end
