/* © 2024 Appstock */

import UIKit

import AppstockSDK
import GoogleMobileAdsAppstockAdapter

import GoogleMobileAds
import AppLovinSDK
import AnyThinkSDK
import IronSource

@main
class AppDelegate: UIResponder, UIApplicationDelegate {

    func application(
        _ application: UIApplication,
        didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?
    ) -> Bool {
        
        // ===== INIT: Appstock SDK
        
        Appstock.initializeSDK(with: "appstock-demo")
        
        // ===== INIT: Google Mobile Ads SDK
        
        MobileAds.shared.start()
        AppstockGADMediationAdapterInitializer.start()
        
        // ===== INIT: AppLovin MAX SDK
        
        let config = ALSdkInitializationConfiguration(
            sdkKey: "<SDK_KEY>"
        )
        
        ALSdk.shared().initialize(with: config)
		
		// ===== INIT: ironSource
		
		let requestBuilder = LPMInitRequestBuilder(appKey: "2277baa3d")
		let initRequest = requestBuilder.build()
		
		LevelPlay.initWith(initRequest) { _, error in
			if let error {
				print("ironSource: init failed with error: \(error)")
			}
		}
        
        // ===== INIT: TopOn
        
        do {
            try ATAPI.sharedInstance().start(
                withAppID: "h66daf2d3e3bf9",
                appKey: "acbf86cf9c9624fe445a6fed7d12c27c7"
            )
        } catch {
            print("Error occured during TopOn SDK initialization: \(error.localizedDescription)")
        }
        
        return true
    }

    // MARK: UISceneSession Lifecycle

    func application(
        _ application: UIApplication,
        configurationForConnecting connectingSceneSession: UISceneSession,
        options: UIScene.ConnectionOptions
    ) -> UISceneConfiguration {
        return UISceneConfiguration(
            name: "Default Configuration",
            sessionRole: connectingSceneSession.role
        )
    }
}
