/* © 2024 Appstock */

import Foundation

enum IntegrationAdFormat: CustomStringConvertible, CaseIterable {
    
    case banner
    case video
    case bannerInterstitial
    case videoInterstitial
    case bannerRewarded
    case videoRewarded
    case native
    
    var description: String {
        switch self {
        case .banner:
            return "Banner"
        case .video:
            return "Video"
        case .bannerInterstitial:
            return "Banner Interstitial"
        case .videoInterstitial:
            return "Video Interstitial"
        case .bannerRewarded:
            return "Banner Rewarded"
        case .videoRewarded:
            return "Video Rewarded"
        case .native:
            return "Native"
        }
    }
}
