/* © 2024 Appstock */

import UIKit

/**
    Integration case title template - [IntegrationKind] [IntegrationAdFormat]
    [IntegrationKind] - Appstock, AdMob, AppLovin, etc
    [IntegrationAdFormat] - "Banner", "Video", "Banner Interstitial", "Video Interstitial", "Native"
 */

struct IntegrationCaseManager {
    
    static var allCases: [IntegrationCase] = [
        
        IntegrationCase(
            title: "Appstock Banner Ad",
            integrationKind: .sdk,
            adFormats: [.banner],
            configurationClosure: {
                AppstockBannerAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "Appstock Video Ad",
            integrationKind: .sdk,
            adFormats: [.video],
            configurationClosure: {
                AppstockVideoAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "Appstock Banner Interstitial",
            integrationKind: .sdk,
            adFormats: [.bannerInterstitial],
            configurationClosure: {
                AppstockBannerInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "Appstock Video Interstitial",
            integrationKind: .sdk,
            adFormats: [.videoInterstitial],
            configurationClosure: {
                AppstockVideoInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "Appstock Banner Rewarded",
            integrationKind: .sdk,
            adFormats: [.bannerRewarded],
            configurationClosure: {
                AppstockBannerRewardedViewController()
            }
        ),
        
        IntegrationCase(
            title: "Appstock Video Rewarded",
            integrationKind: .sdk,
            adFormats: [.videoRewarded],
            configurationClosure: {
                AppstockVideoRewardedViewController()
            }
        ),
        
        IntegrationCase(
            title: "Appstock Native",
            integrationKind: .sdk,
            adFormats: [.native],
            configurationClosure: {
                AppstockNativeViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Banner Ad",
            integrationKind: .adMob,
            adFormats: [.banner],
            configurationClosure: {
                AdMobBannerAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Video Ad",
            integrationKind: .adMob,
            adFormats: [.video],
            configurationClosure: {
                AdMobVideoAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Banner Interstitial",
            integrationKind: .adMob,
            adFormats: [.bannerInterstitial],
            configurationClosure: {
                AdMobBannerInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Video Interstitial",
            integrationKind: .adMob,
            adFormats: [.videoInterstitial],
            configurationClosure: {
                AdMobVideoInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Banner Rewarded",
            integrationKind: .adMob,
            adFormats: [.bannerRewarded],
            configurationClosure: {
                AdMobBannerRewardedViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Video Rewarded",
            integrationKind: .adMob,
            adFormats: [.videoRewarded],
            configurationClosure: {
                AdMobVideoRewardedViewController()
            }
        ),
        
        IntegrationCase(
            title: "AdMob Native",
            integrationKind: .adMob,
            adFormats: [.native],
            configurationClosure: {
                AdMobNativeViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Banner Ad",
            integrationKind: .appLovin,
            adFormats: [.banner],
            configurationClosure: {
                AppLovinBannerAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Video Ad",
            integrationKind: .appLovin,
            adFormats: [.video],
            configurationClosure: {
                AppLovinVideoAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Banner Interstitial",
            integrationKind: .appLovin,
            adFormats: [.bannerInterstitial],
            configurationClosure: {
                AppLovinBannerInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Video Interstitial",
            integrationKind: .appLovin,
            adFormats: [.videoInterstitial],
            configurationClosure: {
                AppLovinVideoInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Banner Rewarded",
            integrationKind: .appLovin,
            adFormats: [.bannerRewarded],
            configurationClosure: {
                AppLovinBannerRewardedViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Video Rewarded",
            integrationKind: .appLovin,
            adFormats: [.videoRewarded],
            configurationClosure: {
                AppLovinVideoRewardedViewController()
            }
        ),
        
        IntegrationCase(
            title: "AppLovin MAX Native",
            integrationKind: .appLovin,
            adFormats: [.native],
            configurationClosure: {
                AppLovinNativeViewController()
            }
        ),
        
        IntegrationCase(
            title: "TopOn Banner Ad",
            integrationKind: .topOn,
            adFormats: [.banner],
            configurationClosure: {
                TopOnBannerAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "TopOn Video Ad",
            integrationKind: .topOn,
            adFormats: [.video],
            configurationClosure: {
                TopOnVideoAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "TopOn Banner Interstitial",
            integrationKind: .topOn,
            adFormats: [.bannerInterstitial],
            configurationClosure: {
                TopOnBannerInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "TopOn Video Interstitial",
            integrationKind: .topOn,
            adFormats: [.videoInterstitial],
            configurationClosure: {
                TopOnVideoInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "TopOn Native",
            integrationKind: .topOn,
            adFormats: [.native],
            configurationClosure: {
                TopOnNativeViewController()
            }
        ),
        
        IntegrationCase(
            title: "ironSource Random Banner Video Ad",
            integrationKind: .ironSource,
            adFormats: [.banner, .video],
            configurationClosure: {
                IronSourceBannerVideoAdViewController()
            }
        ),
        
        IntegrationCase(
            title: "ironSource Random Banner Video Interstitial",
            integrationKind: .ironSource,
            adFormats: [.bannerInterstitial, .videoInterstitial],
            configurationClosure: {
                IronSourceBannerVideoInterstitialViewController()
            }
        ),
        
        IntegrationCase(
            title: "ironSource Random Banner Video Rewarded",
            integrationKind: .ironSource,
            adFormats: [.bannerRewarded, .videoRewarded],
            configurationClosure: {
                IronSourceBannerVideoRewardedViewController()
            }
        ),
    ]
}
