/* © 2024 Appstock */

import UIKit

import AppstockSDK

import GoogleMobileAds

fileprivate let adUnitId = "ca-app-pub-2844566227051243/3239591870"

final class AdMobBannerAdViewController: AdBaseViewController {
    
	private var gadBannerView: GoogleMobileAds.BannerView!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a GoogleMobileAds.BannerView
		gadBannerView = GoogleMobileAds.BannerView(adSize: GoogleMobileAds.AdSizeMediumRectangle)
        
        // 2. Configure the GoogleMobileAds.BannerView
        gadBannerView.adUnitID = adUnitId
        gadBannerView.delegate = self
        gadBannerView.rootViewController = self
        
        // Add GMA SDK banner view to the app UI
        containerAdView.addSubview(gadBannerView)
        
        // 3. Load ad
		gadBannerView.load(GoogleMobileAds.Request())
    }
}

// MARK: - GoogleMobileAds.BannerViewDelegate

extension AdMobBannerAdViewController: GoogleMobileAds.BannerViewDelegate {
    
	func bannerView(_ bannerView: GoogleMobileAds.BannerView, didFailToReceiveAdWithError error: any Error) {
        print("Did fail to receive ad with error: \(error.localizedDescription)")
    }
}
