/* © 2024 Appstock */

import AppstockSDK
import AppLovinSDK

fileprivate let adUnitId = "<AD_UNIT_ID>"

final class AppLovinVideoRewardedViewController: InterstitialBaseViewController {
    
    private var rewardedAd: MARewardedAd!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a MARewardedAd
        rewardedAd = MARewardedAd.shared(withAdUnitIdentifier: adUnitId)
        
        // 2. Configure the MAInterstitialAd
        rewardedAd.delegate = self
        
        // 3. Load the ad
        rewardedAd.load()
    }
}

// MARK: - MARewardedAdDelegate

extension AppLovinVideoRewardedViewController: MARewardedAdDelegate {
   
    func didLoad(_ ad: MAAd) {
        if rewardedAd != nil && rewardedAd.isReady {
            rewardedAd.show()
        }
    }
   
    func didFailToLoadAd(forAdUnitIdentifier adUnitIdentifier: String, withError error: MAError) {
        print("Did fail to load ad with error: \(error.message)")
    }
    
    func didFail(toDisplay ad: MAAd, withError error: MAError) {
        print("Did fail to display ad with error: \(error.message)")
    }
    
    func didRewardUser(for ad: MAAd, with reward: MAReward) {
        print("User did earn reward - label: \(reward.label), amount: \(reward.amount)")
    }
    
    func didDisplay(_ ad: MAAd) {}
    func didHide(_ ad: MAAd) { }
    func didClick(_ ad: MAAd) {}
}
