/* © 2024 Appstock */

import UIKit
import AppstockSDK

fileprivate let placementID = "12"

final class AppstockBannerRewardedViewController: InterstitialBaseViewController {
    
    private var rewardedAdUnit: AppstockRewardedAdUnit!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a AppstockRewardedAdUnit
        rewardedAdUnit = AppstockRewardedAdUnit()
        
        // 2. Configure the AppstockRewardedAdUnit
        rewardedAdUnit.placementID = placementID
        rewardedAdUnit.delegate = self
        
        // 3. Load the rewarded ad
        rewardedAdUnit.loadAd()
    }
}

// MARK: - AppstockRewardedAdUnitDelegate

extension AppstockBannerRewardedViewController: AppstockRewardedAdUnitDelegate {
    
    func rewardedAdDidReceiveAd(_ rewardedAd: AppstockRewardedAdUnit) {
        // Called when ad is loaded. Deprecated.
    }
    
    func rewardedAdDidReceiveAd(_ rewardedAd: AppstockRewardedAdUnit, adInfo: AppstockAdInfo) {
        // Called when ad is loaded.
        rewardedAd.show(from: self)
        print("Bid price: \(String(describing: adInfo.price))")
    }
    
    func rewardedAd(
        _ rewardedAd: AppstockRewardedAdUnit,
        didFailToReceiveAdWithError error: (any Error)?
    ) {
        // Called when Appstock SDK failed to load ad
        print("Did fail to receive ad with error: \(String(describing: error?.localizedDescription))")
    }
    
    func rewardedAdWillPresentAd(_ rewardedAd: AppstockRewardedAdUnit) {
        // Called when rewarded ad is about to be presented
    }

    func rewardedAdDidDismissAd(_ rewardedAd: AppstockRewardedAdUnit) {
        // Called when rewarded ad is dismissed
    }
    
    func rewardedAdDidClickAd(_ rewardedAd: AppstockRewardedAdUnit) {
        // Called when rewarded ad was clicked
    }
    
    func rewardedAdWillLeaveApplication(_ rewardedAd: AppstockRewardedAdUnit) {
        // Called when the application is about to enter the background
    }
    
    func rewardedAdUserDidEarnReward(_ rewardedAd: AppstockRewardedAdUnit, reward: AppstockReward) {
        // Called when the reward was granted to user
        print("User did earn reward - type: \(reward.type ?? ""), count: \(reward.count?.doubleValue ?? 0.0)")
    }
}
