/* © 2024 Appstock */

import UIKit
import AppstockSDK

fileprivate let placementID = "9"

final class AppstockNativeViewController: NativeBaseViewController {
    
    private var nativeAdUnit: AppstockNativeAdUnit!
    private var nativeAd: AppstockNativeAd?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a AppstockNativeAdUnit
        nativeAdUnit = AppstockNativeAdUnit()
        
        // 2. Configure the AppstockNativeAdUnit
        nativeAdUnit.placementID = placementID
        let image = AppstockNativeAssetImage(minimumWidth: 200, minimumHeight: 50, required: true)
        image.type = .Main
        
        let icon = AppstockNativeAssetImage(minimumWidth: 20, minimumHeight: 20, required: true)
        icon.type = .Icon
        
        let title = AppstockNativeAssetTitle(length: 90, required: true)
        let body = AppstockNativeAssetData(type: .description, required: true)
        let cta = AppstockNativeAssetData(type: .ctatext, required: true)
        let sponsored = AppstockNativeAssetData(type: .sponsored, required: true)
        
        let parameters = AppstockNativeParameters()
        parameters.assets = [title, icon, image, sponsored, body, cta]
        
        let eventTracker = AppstockNativeEventTracker(
            event: .Impression,
            methods: [.Image, .js]
        )
        
        parameters.eventtrackers = [eventTracker]
        parameters.context = .Social
        parameters.placementType = .FeedContent
        parameters.contextSubType = .Social
        
        nativeAdUnit.parameters = parameters
        
        nativeAdUnit.loadAd { [weak self] ad, error in
            guard let self = self else {
                return
            }
            
            guard let ad = ad, error == nil else {
                return
            }
            
            self.nativeAd = ad
            self.nativeAd?.delegate = self
            
            // 3. Render the native ad
            self.titleLabel.text = ad.title
            self.bodyLabel.text = ad.text
            self.sponsoredLabel.text = ad.sponsoredBy
            
            self.mainImageView.setImage(from: ad.imageUrl, placeholder: UIImage(systemName: "photo.artframe"))
            self.iconView.setImage(from: ad.iconUrl, placeholder: UIImage(systemName: "photo.artframe"))
            self.callToActionButton.setTitle(ad.callToAction, for: .normal)
            
            self.nativeAd?.registerView(view: self.view, clickableViews: [self.callToActionButton])
            
            print("Bid price: \(String(describing: self.nativeAd?.adInfo?.price))")
        }
    }
}

// MARK: - AppstockNativeAdDelegate

extension AppstockNativeViewController: AppstockNativeAdDelegate {
    
    func adDidExpire(ad: AppstockNativeAd) {
        // Called when the ad expired
    }
    
    func adWasClicked(ad: AppstockNativeAd) {
        // Called when the ad was clicked
    }
    
    func adDidLogImpression(ad: AppstockNativeAd) {
        // Called when the impression was logged
    }
}
