/* © 2024 Appstock */

import UIKit
import AppstockSDK

fileprivate let placementID = "7"

final class AppstockVideoInterstitialViewController: InterstitialBaseViewController {
    
    private var interstitialAdUnit: AppstockInterstitialAdUnit!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Create a AppstockInterstitialAdUnit
        interstitialAdUnit = AppstockInterstitialAdUnit()
        
        // 2. Configure the AppstockInterstitialAdUnit
        interstitialAdUnit.placementID = placementID
        interstitialAdUnit.delegate = self
        
        // 3. Load the interstitial ad
        interstitialAdUnit.loadAd()
    }
}

// MARK: - AppstockInterstitialAdUnitDelegate

extension AppstockVideoInterstitialViewController: AppstockInterstitialAdUnitDelegate {
    
    func interstitialDidReceiveAd(_ interstitial: AppstockInterstitialAdUnit) {
        // Called when ad is loaded. Deprecated.
    }
    
    func interstitialDidReceiveAd(_ interstitial: AppstockInterstitialAdUnit, adInfo: AppstockAdInfo) {
        // Called when ad is loaded.
        interstitial.show(from: self)
        print("Bid price: \(String(describing: adInfo.price))")
    }
    
    func interstitial(
        _ interstitial: AppstockInterstitialAdUnit,
        didFailToReceiveAdWithError error: (any Error)?
    ) {
        // Called when Appstock SDK failed to load ad
        print("Did fail to receive ad with error: \(String(describing: error?.localizedDescription))")
    }
    
    func interstitialWillPresentAd(_ interstitial: AppstockInterstitialAdUnit) {
        // Called when interstitial is about to be presented
    }
    
    func interstitialDidDismissAd(_ interstitial: AppstockInterstitialAdUnit) {
        // Called when interstitial is dismissed
    }
    
    func interstitialDidClickAd(_ interstitial: AppstockInterstitialAdUnit) {
        // Called when interstitial was clicked
    }
    
    func interstitialWillLeaveApplication(_ interstitial: AppstockInterstitialAdUnit) {
        // Called when the application is about to enter the background
    }
}
