/* © 2024 Appstock */

import UIKit

import AppstockSDK
import AppstockTopOnAdapter

import AnyThinkBanner

fileprivate let placementID = "n66daf48287b5e"

class TopOnBannerAdViewController: AdBaseViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Setup ad
        let extra = [
            kATAdLoadingExtraBannerAdSizeKey: NSValue(cgSize: CGSize(width: 300, height: 250))
        ]
        
        // 2. Load the ad
        ATAdManager.shared().loadAD(withPlacementID: placementID, extra: extra, delegate: self)
    }
}

// MARK: - ATAdLoadingDelegate

extension TopOnBannerAdViewController: ATAdLoadingDelegate {
    
    func didFinishLoadingAD(withPlacementID placementID: String!) {
        // 3. Check if banner is ready
        if ATAdManager.shared().bannerAdReady(forPlacementID: placementID) {
            let tag = 3333
            view.viewWithTag(tag)?.removeFromSuperview()
            
            // 4. Retrieve banner view
            if let bannerView = ATAdManager.shared().retrieveBannerView(forPlacementID: placementID) {
                // 5. Add GMA SDK banner view to the app UI
                containerAdView.addSubview(bannerView)
            }
        }
    }
    
    func didFailToLoadAD(withPlacementID placementID: String!, error: (any Error)!) {
        print("Did fail to load ad: \(error.localizedDescription)")
    }
    
    func didFailToLoadADSource(
        withPlacementID placementID: String!,
        extra: [AnyHashable : Any]!,
        error: (any Error)!
    ) {
        print("Did fail to load ad source: \(error.localizedDescription)")
    }
    
    func didFailBiddingADSource(
        withPlacementID placementID: String!,
        extra: [AnyHashable : Any]!,
        error: (any Error)!
    ) {
        print("Did fail bidding ad source: \(error.localizedDescription)")
    }
    
    func didRevenue(forPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didStartLoadingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didFinishLoadingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didStartBiddingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didFinishBiddingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
}
