/* © 2024 Appstock */

import UIKit

import AppstockSDK
import AppstockTopOnAdapter

import AnyThinkInterstitial

fileprivate let placementID = "n66daf482141ac"

final class TopOnVideoInterstitialViewController: InterstitialBaseViewController {
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        loadAd()
    }
    
    private func loadAd() {
        // 1. Load the ad
        ATAdManager.shared().loadAD(
            withPlacementID: placementID,
            extra: [:],
            delegate: self
        )
    }
}

// MARK: ATAdLoadingDelegate

extension TopOnVideoInterstitialViewController: ATAdLoadingDelegate {
    
    func didFinishLoadingAD(withPlacementID placementID: String!) {
        // 2. Check if ad is ready to be shown
        if ATAdManager.shared().interstitialReady(forPlacementID: placementID) {
            // 3. Show the ad
            ATAdManager.shared().showInterstitial(
                withPlacementID: placementID,
                in: self,
                delegate: self
            )
        }
    }
    
    func didFailToLoadAD(withPlacementID placementID: String!, error: (any Error)!) {
        print("Did fail to load ad: \(error.localizedDescription)")
    }
    
    func didFailToLoadADSource(
        withPlacementID placementID: String!,
        extra: [AnyHashable : Any]!,
        error: (any Error)!
    ) {
        print("Did fail to load ad source: \(error.localizedDescription)")
    }
    
    func didFailBiddingADSource(
        withPlacementID placementID: String!,
        extra: [AnyHashable : Any]!,
        error: (any Error)!
    ) {
        print("Did fail bidding ad source: \(error.localizedDescription)")
    }
    
    func didRevenue(forPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didStartLoadingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didFinishLoadingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didStartBiddingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
    func didFinishBiddingADSource(withPlacementID placementID: String!, extra: [AnyHashable : Any]!) {}
}

// MARK: - ATInterstitialDelegate

extension TopOnVideoInterstitialViewController: ATInterstitialDelegate {
    
    func interstitialDidShow(forPlacementID placementID: String, extra: [AnyHashable : Any]) {}
    func interstitialDidClick(forPlacementID placementID: String, extra: [AnyHashable : Any]) {}
    func interstitialDidClose(forPlacementID placementID: String, extra: [AnyHashable : Any]) {}
}
