/* © 2024 Appstock */

import AppstockSDK
import IronSource

fileprivate let adUnitId = "lm4bvvi8vs39gyad"

class IronSourceBannerVideoAdViewController: AdBaseViewController {
	
	private var bannerView: LPMBannerAdView?
	
	override func viewDidLoad() {
		super.viewDidLoad()
		
		loadAd()
	}
	
	private func loadAd() {
		// 1. Create LPMBannerAdViewConfig
		let size = LPMAdSize.customSize(withWidth: 300, height: 250)
		let adConfig = LPMBannerAdViewConfigBuilder()
			.set(adSize: size)
			.build()
		
		// 2. Create LPMBannerAdView
		let bannerView = LPMBannerAdView(adUnitId: adUnitId, config: adConfig)
		bannerView.frame = CGRect(
			origin: .zero,
			size: CGSize(
				width: size.width,
				height: size.height
			)
		)
		
		// 3. Store instance of LPMBannerAdView
		self.bannerView = bannerView
		
		// 4. Add ironSource SDK banner view to the app UI
		containerAdView.addSubview(bannerView)
		
		// 5. Set delegate
		bannerView.setDelegate(self)
		
		// 6. Load the ad
		bannerView.loadAd(with: self)
	}
}

// MARK: - LPMBannerAdViewDelegate

extension IronSourceBannerVideoAdViewController: LPMBannerAdViewDelegate {
	
	func didFailToLoadAd(withAdUnitId adUnitId: String, error: any Error) {
		print("Did fail to load ad with error: \(error.localizedDescription)")
	}
	
	func didFailToDisplayAd(with adInfo: LPMAdInfo, error: any Error) {
		print("Did fail to display ad with error: \(error.localizedDescription)")
	}
	
	func didLoadAd(with adInfo: LPMAdInfo) {}
	func didClickAd(with adInfo: LPMAdInfo) {}
	func didLeaveApp(with adInfo: LPMAdInfo) {}
	func didExpandAd(with adInfo: LPMAdInfo) {}
	func didCollapseAd(with adInfo: LPMAdInfo) {}
}

