/* © 2024 Appstock */

import AppstockSDK
import IronSource

fileprivate let adUnitId = "nthv9kz3dlew119l"

class IronSourceBannerVideoInterstitialViewController: InterstitialBaseViewController {
	
	private var interstitialAd: LPMInterstitialAd?

	override func viewDidLoad() {
		super.viewDidLoad()

		loadAd()
	}
	
	private func loadAd() {
		// 1. Create LPMInterstitialAd
		let interstitialAd = LPMInterstitialAd(adUnitId: adUnitId)
		
		// 2. Store interstitialAd instance
		self.interstitialAd = interstitialAd
		
		// 3. Set delegate
		interstitialAd.setDelegate(self)
		
		// 4. Load the ad
		interstitialAd.loadAd()
	}
}

// MARK: - LPMInterstitialAdDelegate

extension IronSourceBannerVideoInterstitialViewController: LPMInterstitialAdDelegate {
	
	func didLoadAd(with adInfo: LPMAdInfo) {
		// 5. Check if interstitial ad is available
		if interstitialAd?.isAdReady() == true {
			// 5. Show the ad
			interstitialAd?.showAd(
				viewController: self,
				placementName: nil
			)
		}
	}
	
	func didFailToLoadAd(withAdUnitId adUnitId: String, error: any Error) {
		print("Did fail to load the ad with error: \(error.localizedDescription)")
	}
	
	func didFailToDisplayAd(with adInfo: LPMAdInfo, error: any Error) {
		print("Did fail to show the ad with error: \(error.localizedDescription)")
	}
	
	func didDisplayAd(with adInfo: LPMAdInfo) {}
	func didClickAd(with adInfo: LPMAdInfo) {}
	func didCloseAd(with adInfo: LPMAdInfo) {}
}
