/* © 2024 Appstock */

import AppstockSDK
import IronSource

fileprivate let adUnitId = "yazrjdrk2jx6p030"

class IronSourceBannerVideoRewardedViewController: InterstitialBaseViewController {
	
	private var rewardedAd: LPMRewardedAd?
	
	override func viewDidLoad() {
		super.viewDidLoad()

		loadAd()
	}
	
	private func loadAd() {
		// 1. Create LPMRewardedAd instance
		let rewardedAd = LPMRewardedAd(adUnitId: adUnitId)
		
		// 2. Store LPMRewardedAd  instance
		self.rewardedAd = rewardedAd
		
		// 3. Set delegate
		rewardedAd.setDelegate(self)
		
		// 4. Load the ad
		rewardedAd.loadAd()
	}
}

extension IronSourceBannerVideoRewardedViewController: LPMRewardedAdDelegate {
	
	func didLoadAd(with adInfo: LPMAdInfo) {
		// 5. Check if rewarded ad is available
		if rewardedAd?.isAdReady() == true {
			// 6. Show the ad
			rewardedAd?.showAd(
				viewController: self,
				placementName: nil
			)
		}
	}
	
	func didFailToLoadAd(withAdUnitId adUnitId: String, error: any Error) {
		print("Did fail to load ad with error: \(error.localizedDescription)")
	}
	
	func didFailToDisplayAd(with adInfo: LPMAdInfo, error: any Error) {
		print("Did fail to show ad with error: \(error.localizedDescription)")
	}
	
	func didRewardAd(with adInfo: LPMAdInfo, reward: LPMReward) {
		print("Did receive reward")
	}
	
	func didDisplayAd(with adInfo: LPMAdInfo) {}
	func didClickAd(with adInfo: LPMAdInfo) {}
	func didCloseAd(with adInfo: LPMAdInfo) {}	
}
