/* © 2024 Appstock */

import Foundation

enum IntegrationKind: CustomStringConvertible, CaseIterable {
    
    case sdk
    case adMob
    case appLovin
    case topOn
    case ironSource
    
    var description: String {
        switch self {
        case .sdk:
            return "Appstock"
        case .adMob:
            return "AdMob"
        case .appLovin:
            return "AppLovin MAX"
        case .topOn:
            return "TopOn"
        case .ironSource:
            return "ironSource"
        }
    }
}
