# Appstock SDK iOS - Overview

Appstock SDK is a native library that monetizes iOS applications. The latest SDK version is **1.1.3**.

The minimum deployment target is **iOS 12.0**.

Demo applications (Swift, ObjC): https://public-sdk.al-ad.com/ios/appstock-demo/demo-app-1.1.3/demo-app-1.1.3.zip

## Integration and configuration

Follow the [integration instructions](./1.1-appstock-sdk-ios-integration.md#appstock-sdk-ios---integration) to add the SDK to your app. Once the SDK is integrated, you can provide [configuration options](./1.6-appstock-sdk-ios-parametrization.md#appstock-sdk-ios---sdk-parametrization) that will help increase your revenue. Keep in mind that the SDK supports basic [consent providers](./1.7-appstock-sdk-ios-consent-management.md#appstock-sdk-ios---consent-management) according to industry standards.  

Appstock SDK supports the following ad formats: 

- [Banner](./1.2-appstock-sdk-ios-banner.md#appstock-sdk-ios---banner) (HTML or Video)
- [Interstitial](./1.3-appstock-sdk-ios-interstitial.md#appstock-sdk-ios---interstitial) (HTML and Video)
- [Rewarded](./1.4-appstock-sdk-ios-rewarded.md#appstock-sdk-ios---rewarded) (HTML and Video)
- [Native](./1.5-appstock-sdk-ios-native.md#appstock-sdk-ios---native)

The SDK can be integrated directly into your app or via supported Mediation Adapters: 

- [AppLovin MAX](./1.9-appstock-sdk-ios-applovin.md#appstock-sdk-ios---mediation---applovin)
- [GMA SDK](./1.8-appstock-sdk-ios-admob.md#appstock-sdk-ios---mediation---admob) (AdMob, GAM) 
- [TopOn](./2.0-appstock-sdk-ios-topon.md#appstock-sdk-ios---mediation---topon)
- [ironSource](./2.1-appstock-sdk-ios-ironsource.md#appstock-sdk-ios---mediation---ironsource)
