# Appstock SDK iOS - Integration

Appstock SDK is available for integration via CocoaPods dependency manager and direct download of the compiled framework.

## Cocoapods

We assume the [CocoaPods](https://cocoapods.org/) dependency manager has already been integrated into the project. If not, follow the “Get Started” instructions on cocoapods.org.

Add this line into your Podfile within the application target:

```bash
pod 'AppstockSDK', '1.1.3'
```

Then run `pod install --repo-update`.

## Direct download

The Appstock SDK is also available via a direct download link: https://public-sdk.al-ad.com/ios/appstock-sdk/1.1.3/AppstockSDK.xcframework.zip

## SDK Initialization

Import the Appstock SDK core class in the main application class:

```swift
import AppstockSDK
```

Initialize Appstock SDK in the `application:didFinishLaunchingWithOptions` method by calling `Appstock.initializeSDK()` method.

*Swift*

```swift 
func application(_ application: UIApplication, 
didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {  
    // Initialize SDK SDK.
    Appstock.initializeSDK(with: PARTNER_KEY)
}
```

*Objective-C*

```objc
- (BOOL)application:(UIApplication *)application 
didFinishLaunchingWithOptions:(NSDictionary<UIApplicationLaunchOptionsKey, id> *)launchOptions {
    // Initialize SDK SDK.
    [Appstock initializeSDKWithPartnerKey:PARTNER_KEY];
    return YES;
}
```

The `Appstock.initializeSdk()` method has a parameter:

- **partnerKey** - determines the Appstock server URL. The Appstock account manager should provide you with this key.

It is recommended that contextual information be provided after initialization to enrich the ad requests. For this purpose, use [SDK parametrization](./1.6-appstock-sdk-ios-parametrization.md#appstock-sdk-ios---sdk-parametrization) properties.

Once SDK is initialized and all needed parameters are provided, it is ready to request the ads.
