# Appstock SDK iOS - SDK Parametrization

## Configuration via `AppstockTargeting` class

The `AppstockTargeting` class provided a set of properties that allow to enrich the ad request. 


| Method                           | Description                                                                                                                   | OpenRTB field              |
|----------------------------------|:------------------------------------------------------------------------------------------------------------------------------|----------------------------|
| AppstockTargeting.userExt        | Placeholder for exchange-specific extensions to OpenRTB.                                                                      | user.ext                   |
| AppstockTargeting.userCustomData | Set the specific user data                                                                                                    | user.customdata            |
| AppstockTargeting.subjectToCOPPA | Integer flag indicating if this request is subject to the COPPA regulations established by the USA FTC, where 0 = no, 1 = yes | regs.coppa                 |
| AppstockTargeting.storeURL       | App store URL for an installed app.                                                                                           | app.storeurl               |
| AppstockTargeting.sourceapp      | ID of publisher app in Apple’s App Store.                                                                                     | imp[].ext.skadn.sourceapp  |
| AppstockTargeting.publisherName  | App's publisher name                                                                                                          | app.publisher.name         |
| AppstockTargeting.itunesID       | The app identifier in iTunes.                                                                                                 | app.bundle                 |
| AppstockTargeting.eids           | Placeholder for User Identity Links                                                                                           | usr.ext.eids               |
| AppstockTargeting.externalUserIds           | Defines the User Id Object from an External Thrid Party Source.                                                                                           | usr.ext.eids               |
| AppstockTargeting.domain         | Domain of the app (e.g., “mygame.foo.com”).                                                                                   | app.domain                 |
| AppstockTargeting.coordinate     | Location of the user’s home base. This is not necessarily their current location                                              | user.geo.lat,<br />user.geo.lon |
| AppstockTargeting.addAppKeyword  | Comma-separated list of keywords about the app                                                                                | app.keywords               |

Usage examples: 

*Swift*

```swift
// Set the userExt property
AppstockTargeting.shared.userExt = ["customField": "value"]

// Set the userCustomData property
AppstockTargeting.shared.userCustomData = "{\"key\":\"value\"}"

// Set the subjectToCOPPA property
AppstockTargeting.shared.subjectToCOPPA = true

// Set the storeURL property
AppstockTargeting.shared.storeURL = "https://appstore.com/app"

// Set the sourceapp property
AppstockTargeting.shared.sourceapp = "com.example.app"

// Set the publisherName property
AppstockTargeting.shared.publisherName = "MyPublisher"

// Set the itunesID property
AppstockTargeting.shared.itunesID = "123456789"

// Set the eids property
AppstockTargeting.shared.eids = [["uids":["id": "123"], "source": "idfa"]]

// Set the externalUserIds property
AppstockTargeting.shared.externalUserIds = 
[AppstockExternalUserId(source: "adserver.org", identifier: 
"111111111111", ext: ["partner" : "abs"])]

// Set the domain property
AppstockTargeting.shared.domain = "mygame.foo.com"

// Set the coordinate property
AppstockTargeting.shared.coordinate = NSValue(cgCoordinate: 
CLLocationCoordinate2D(latitude: 37.7749, longitude: -122.4194))

// Add a keyword
AppstockTargeting.shared.addAppKeyword("gaming")
```

*Objective-C*

```objc
// Set the userExt property
AppstockTargeting.shared.userExt = @{@"customField": @"value"};

// Set the userCustomData property
AppstockTargeting.shared.userCustomData = @"{\"key\":\"value\"}";

// Set the subjectToCOPPA property
AppstockTargeting.shared.subjectToCOPPAObjc = @1;

// Set the storeURL property
AppstockTargeting.shared.storeURL = @"https://appstore.com/app";

// Set the sourceapp property
AppstockTargeting.shared.sourceapp = @"com.example.app";

// Set the publisherName property
AppstockTargeting.shared.publisherName = @"MyPublisher";

// Set the itunesID property
AppstockTargeting.shared.itunesID = @"123456789";

// Set the eids property
AppstockTargeting.shared.eids = @[@{@"uids": @{@"id": @"123"}, @"source": @"idfa"}];

// Set the externalUserIds property
AppstockTargeting.shared.externalUserIds = @[[[AppstockExternalUserId 
alloc] initWithSource:@"adserver.org" identifier:@"111111111111" atype:@1 
ext:@{@"partner": @"abs"}]];

// Set the domain property
AppstockTargeting.shared.domain = @"mygame.foo.com";

// Set the coordinate property
AppstockTargeting.shared.coordinate = [NSValue 
valueWithMKCoordinate:CLLocationCoordinate2DMake(37.7749, -122.4194)];

// Add a keyword
[AppstockTargeting.shared addAppKeyword:@"gaming"];
```

## Configuration via `Appstock` class

`Appstock` class provides some properties to configure SDK and ad request. Here is a brief overview: 

| Property/Method                    | Description                                                                          |
|------------------------------------|--------------------------------------------------------------------------------------|
| `timeoutUpdated`                   | Indicates whether the ad request timeout has been updated.                           |
| `debugRequests`                    | Enables or disables debug mode for requests.                                    |
| `endpointID`                       | A unique identifier generated on the platform's UI.                                  |
| `shouldAssignNativeAssetID`        | Determines whether the asset ID for native ads should be manually assigned.          |
| `shareGeoLocation`                 | Controls whether location data is shared for better ad targeting.                    |
| `logLevel`                         | Sets the desired verbosity of the logs.                                              |
| `externalUserIdArray`              | An array containing objects that hold external user ID parameters.                   |
| `version`                          | Returns the SDK version.                                                             |
| `omsdkVersion`                     | Returns the OM SDK version used by the SDK.                                          |
| `timeoutMillis`                    | The timeout in milliseconds for ad requests.                                         |
| `timeoutMillisDynamic`             | The dynamic timeout value set when `timeoutMillis` changes.                          |
| `adRequestTimeout`                 | The time interval allowed for a creative to load before it is considered a failure.  |
| `adRequestTimeoutPreRenderContent` | The time interval allowed for video and interstitial creatives to load.              |
| `initializeSDK(with partnerKey)`   | Initializes the Appstock SDK with the provided partner key.                          |

Usage examples:

*Swift*

```swift
// Setting the timeoutUpdated flag
Appstock.shared.timeoutUpdated = true

// Enabling debug logging
Appstock.shared.debugRequests = true

// Setting the endpoint ID
Appstock.shared.endpointID = "12345"

// Managing the asset ID for native ads
Appstock.shared.shouldAssignNativeAssetID = true

// Sharing location data for targeted ads
Appstock.shared.shareGeoLocation = true

// Setting the log level to debug
Appstock.shared.logLevel = .debug

// Adding an external user ID
Appstock.shared.externalUserIdArray = [AppstockExternalUserId(
source: "adserver.org", identifier: "111111111111", 
ext: ["partner" : "abs"])]

// Accessing the SDK version
let sdkVersion = Appstock.shared.version

// Accessing the OM SDK version
let omVersion = Appstock.shared.omsdkVersion

// Setting the timeout for ad requests
Appstock.shared.timeoutMillis = 5000

// Adjusting the creative load time
Appstock.shared.adRequestTimeout = 8.0

// Adjusting the pre-rendered content load time
Appstock.shared.adRequestTimeoutPreRenderContent = 20.0

// Initializing the SDK
Appstock.initializeSDK(with: "partner-key")
```

*Objective-C*

```objc
// Setting the timeoutUpdated flag
Appstock.shared.timeoutUpdated = YES;

// Enabling debug logging
Appstock.shared.debugRequests = YES;

// Setting the endpoint ID
Appstock.shared.endpointID = @"12345";

// Managing the asset ID for native ads
Appstock.shared.shouldAssignNativeAssetID = YES;

// Sharing location data for targeted ads
Appstock.shared.shareGeoLocation = YES;

// Setting the log level to debug
Appstock.shared.logLevel = APSLogLevel.debug;

// Adding an external user ID
Appstock.shared.externalUserIdArray = @[[[AppstockExternalUserId alloc] 
initWithSource:@"adserver.org" identifier:@"111111111111" atype:@1 
ext:@{@"partner": @"abs"}]];

// Accessing the SDK version
NSString *sdkVersion = Appstock.shared.version;

// Accessing the OM SDK version
NSString *omVersion = Appstock.shared.omsdkVersion;

// Setting the timeout for ad requests
Appstock.shared.timeoutMillis = 5000;

// Adjusting the creative load time
Appstock.shared.adRequestTimeout = 8.0;

// Adjusting the pre-rendered content load time
Appstock.shared.adRequestTimeoutPreRenderContent = 20.0;

// Initializing the SDK
[Appstock initializeSDKWith:@"partner-key"];
```