/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <Foundation/Foundation.h>

@class UIView;
@class UIViewController;

@class APSAbstractCreative;
@class APSAdDetails;
@class APSAdViewManager;
@class APSInterstitialDisplayProperties;

// This protocol defines the communication from the APSAdViewManager to the APSAdView
NS_ASSUME_NONNULL_BEGIN
@protocol APSAdViewManagerDelegate <NSObject>

@required
- (nullable UIViewController *)viewControllerForModalPresentation;

- (void)adLoaded:(APSAdDetails *)tbAdDetails;
- (void)failedToLoad:(NSError *)error;

- (void)adDidComplete;
- (void)adDidDisplay;

- (void)adWasClicked;
- (void)adViewWasClicked;

- (void)adDidExpand;
- (void)adDidCollapse;

- (void)adDidLeaveApp;

- (void)adClickthroughDidClose;

- (void)adDidClose;

@optional
//Only used by AdView & APSVideoAdView
// The actual top layer view that displays the ad
- (UIView *)displayView;

//Only used by APSVideoAdView, APSDisplayView, InterstitialController
//Note: all of them seem to simply return a new object.
//TODO: Verify whether the instantiation of an object should be inside the delegate.
- (APSInterstitialDisplayProperties *)interstitialDisplayProperties;

- (void)videoAdDidFinish;
- (void)videoAdWasMuted;
- (void)videoAdWasUnmuted;

// Used only for rewarded API
- (void)adDidSendRewardedEvent;

@end
NS_ASSUME_NONNULL_END

