/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NSDictionary<NSString *, id> APSJsonDictionary;
@compatibility_alias JsonDictionary APSJsonDictionary;

typedef NSMutableDictionary<NSString *, id> APSMutableJsonDictionary;
@compatibility_alias MutableJsonDictionary APSMutableJsonDictionary;

FOUNDATION_EXPORT const NSTimeInterval APSAdPrefetchTime;

FOUNDATION_EXPORT NSString * const APS_DOMAIN_KEY;
FOUNDATION_EXPORT NSString * const APS_TRANSACTION_STATE_KEY;
FOUNDATION_EXPORT NSString * const APS_TRACKING_URL_TEMPLATE;
FOUNDATION_EXPORT NSString * const APS_ORIGINAL_ADUNIT_KEY;
FOUNDATION_EXPORT NSString * const APS_PRECACHE_CONFIGURATION_KEY;

typedef NS_ENUM(NSInteger, APSLocationSourceValues) {
    APSLocationSourceValuesGPS NS_SWIFT_NAME(GPS) = 1,                              //From Location Service
    APSLocationSourceValuesIPAddress NS_SWIFT_NAME(IPAddress) = 2,                  //Unused by SDK
    APSLocationSourceValuesUserRegistration NS_SWIFT_NAME(UserRegistration) = 3     //Supplied by Publisher
};

//MARK: Accessibility
@interface APSAccesibility: NSObject

//Main close button that appears on Interstitials & Clickthrough Browsers
@property (class, readonly) NSString *CloseButtonIdentifier;
@property (class, readonly) NSString *CloseButtonLabel;

//Secondary close button that only appears on the bottom bar of Clickthrough Browsers
@property (class, readonly) NSString *CloseButtonClickThroughBrowserIdentifier;
@property (class, readonly) NSString *CloseButtonClickThroughBrowserLabel;

@property (class, readonly) NSString *WebViewLabel;

@property (class, readonly) NSString *VideoAdView;

@property (class, readonly) NSString *AdView;

@end

//MARK: MRAID
typedef NSString * APSMRAIDState NS_TYPED_ENUM;
FOUNDATION_EXPORT APSMRAIDState const APSMRAIDStateNotEnabled;
FOUNDATION_EXPORT APSMRAIDState const APSMRAIDStateDefault;
FOUNDATION_EXPORT APSMRAIDState const APSMRAIDStateExpanded;
FOUNDATION_EXPORT APSMRAIDState const APSMRAIDStateHidden;
FOUNDATION_EXPORT APSMRAIDState const APSMRAIDStateLoading;
FOUNDATION_EXPORT APSMRAIDState const APSMRAIDStateResized;


//MARK: Tracking Supression Detection Strings
typedef NSString * APSTrackingPattern NS_TYPED_ENUM;
FOUNDATION_EXPORT APSTrackingPattern const APSTrackingPatternRI;
FOUNDATION_EXPORT APSTrackingPattern const APSTrackingPatternRC;
FOUNDATION_EXPORT APSTrackingPattern const APSTrackingPatternRDF;
FOUNDATION_EXPORT APSTrackingPattern const APSTrackingPatternRR;
FOUNDATION_EXPORT APSTrackingPattern const APSTrackingPatternBO;


//MARK: Query String Parameters
typedef NSString * APSParameterKeys NS_TYPED_ENUM;
FOUNDATION_EXPORT APSParameterKeys const APSParameterKeysAPP_STORE_URL;
FOUNDATION_EXPORT APSParameterKeys const APSParameterKeysOPEN_RTB;

//MARK: APSLocationParamKeys
NS_SWIFT_NAME(APSLocationParamKeys)
@interface APSLocationParamKeys: NSObject

@property (class, readonly) NSString *Latitude                          NS_SWIFT_NAME(Latitude);
@property (class, readonly) NSString *Longitude                         NS_SWIFT_NAME(Longitude);
@property (class, readonly) NSString *Country                           NS_SWIFT_NAME(Country);
@property (class, readonly) NSString *City                              NS_SWIFT_NAME(City);
@property (class, readonly) NSString *State                             NS_SWIFT_NAME(State);
@property (class, readonly) NSString *Zip                               NS_SWIFT_NAME(Zip);
@property (class, readonly) NSString *LocationSource                    NS_SWIFT_NAME(LocationSource);

@end


//MARK: JSON Parse Keys
//TODO: Change Name
NS_SWIFT_NAME(APSParseKey)
@interface APSParseKey: NSObject

@property (class, readonly) NSString *ADUNIT                            NS_SWIFT_NAME(ADUNIT);
@property (class, readonly) NSString *HEIGHT                            NS_SWIFT_NAME(HEIGHT);
@property (class, readonly) NSString *WIDTH                             NS_SWIFT_NAME(WIDTH);
@property (class, readonly) NSString *HTML                              NS_SWIFT_NAME(HTML);
@property (class, readonly) NSString *IMAGE                             NS_SWIFT_NAME(IMAGE);
@property (class, readonly) NSString *NETWORK_UID                       NS_SWIFT_NAME(NETWORK_UID);
@property (class, readonly) NSString *REVENUE                           NS_SWIFT_NAME(REVENUE);
@property (class, readonly) NSString *SSM_TYPE                          NS_SWIFT_NAME(SSM_TYPE);

@end


//MARK: APSAutoRefresh
@interface APSAutoRefresh: NSObject

@property (class, readonly) NSTimeInterval AUTO_REFRESH_DELAY_DEFAULT   NS_SWIFT_NAME(AUTO_REFRESH_DELAY_DEFAULT);
@property (class, readonly) NSTimeInterval AUTO_REFRESH_DELAY_MIN       NS_SWIFT_NAME(AUTO_REFRESH_DELAY_MIN);
@property (class, readonly) NSTimeInterval AUTO_REFRESH_DELAY_MAX       NS_SWIFT_NAME(AUTO_REFRESH_DELAY_MAX);

@end


//MARK: Other Time Intervals
@interface APSTimeInterval: NSObject

@property (class, readonly) NSTimeInterval VAST_LOADER_TIMEOUT          NS_SWIFT_NAME(VAST_LOADER_TIMEOUT);
@property (class, readonly) NSTimeInterval AD_CLICKED_ALLOWED_INTERVAL  NS_SWIFT_NAME(AD_CLICKED_ALLOWED_INTERVAL);
@property (class, readonly) NSTimeInterval CONNECTION_TIMEOUT_DEFAULT   NS_SWIFT_NAME(CONNECTION_TIMEOUT_DEFAULT);
@property (class, readonly) NSTimeInterval CLOSE_DELAY_MIN              NS_SWIFT_NAME(CLOSE_DELAY_MIN);
@property (class, readonly) NSTimeInterval CLOSE_DELAY_MAX              NS_SWIFT_NAME(CLOSE_DELAY_MAX);
@property (class, readonly) NSTimeInterval FIRE_AND_FORGET_TIMEOUT      NS_SWIFT_NAME(FIRE_AND_FORGET_TIMEOUT);

@end


@interface APSVideoConstants: NSObject

@property (class, readonly) NSInteger VIDEO_TIMESCALE                   NS_SWIFT_NAME(VIDEO_TIMESCALE);

@end


//MARK: APSGeoLocationConstants
NS_SWIFT_NAME(APSGeoLocationConstants)
@interface APSGeoLocationConstants: NSObject

@property (class, readonly) double DISTANCE_FILTER                      NS_SWIFT_NAME(DISTANCE_FILTER);

@end


//MARK: APSConstants
@interface APSConstants: NSObject

@property (class, readonly) NSArray <NSString *> *supportedVideoMimeTypes           NS_SWIFT_NAME(supportedVideoMimeTypes);
@property (class, readonly) NSArray <NSString *> *urlSchemesForAppStoreAndITunes    NS_SWIFT_NAME(urlSchemesForAppStoreAndITunes);
@property (class, readonly) NSArray <NSString *> *urlSchemesNotSupportedOnSimulator NS_SWIFT_NAME(urlSchemesNotSupportedOnSimulator);
@property (class, readonly) NSArray <NSString *> *urlSchemesNotSupportedOnClickthroughBrowser NS_SWIFT_NAME(urlSchemesNotSupportedOnClickthroughBrowser);
@property (class, readonly) NSNumber *BUTTON_AREA_DEFAULT                           NS_SWIFT_NAME(BUTTON_AREA_DEFAULT);
@property (class, readonly) NSNumber *SKIP_DELAY_DEFAULT                            NS_SWIFT_NAME(SKIP_DELAY_DEFAULT);
@property (class, readonly) NSNumber *buttonConstraintConstant                      NS_SWIFT_NAME(buttonConstraintConstant);

@end


NS_ASSUME_NONNULL_END
