/* © 2024 Appstock */

#import "APSORTBAbstract.h"
#import "APSORTBAbstract+Protected.h"

NS_ASSUME_NONNULL_BEGIN

/// Describes the close behavior. How should the SDK manage the ad when it is encountered as viewed
@interface APSORTBBidExtRewardedClose : APSORTBAbstract

/// The time interval in seconds passed after the reward event when SDK should close the interstitial
@property (nonatomic, strong, nullable) NSNumber *postrewardtime;

/// The action that SDK should do.
/// Available options:
/// - autoclose - close the interstitial;
/// - closebutton - show the close button.
@property (nonatomic, strong, nullable) NSString *action;

@end

NS_ASSUME_NONNULL_END
