/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <Foundation/Foundation.h>
#import "APSORTBBidExtSkadn.h"

@protocol APSTransactionDelegate;

@class WKWebView;
@class UIView;
@class APSModalManager;
@class APSAdConfiguration;
@class APSCreativeModel;
@class APSAbstractCreative;
@class APSAdDetails;
@class APSOpenMeasurementSession;
@class APSOpenMeasurementWrapper;
@class APSORTBBidExtSkadn;

@protocol AppstockServerConnectionProtocol;

NS_ASSUME_NONNULL_BEGIN
@interface APSTransaction: NSObject

@property (nonatomic, readonly, nonnull) APSAdConfiguration *adConfiguration; // If need to change use resetAdConfiguration
@property (nonatomic, strong) NSMutableArray<APSAbstractCreative *> *creatives;
@property (nonatomic, strong) NSArray<APSCreativeModel *> *creativeModels;
@property (nonatomic, strong, nullable) APSOpenMeasurementSession *measurementSession;
@property (nonatomic, strong) APSOpenMeasurementWrapper *measurementWrapper;

@property (nonatomic, strong, nullable) APSORTBBidExtSkadn *skadnInfo;
@property (nonatomic, strong, nullable) NSString *impURL; // bidResponse.ext.mobilesdk.events.imp
@property (nonatomic, strong, nullable) NSString *winURL; // bidResponse.ext.mobilesdk.events.win

@property (atomic, weak, nullable) id<APSTransactionDelegate> delegate;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)initWithServerConnection:(id<AppstockServerConnectionProtocol>)connection
                         adConfiguration:(APSAdConfiguration *)adConfiguration
                                  models:(NSArray<APSCreativeModel *> *)creativeModels NS_DESIGNATED_INITIALIZER;

- (void)startCreativeFactory;
- (nullable APSAdDetails *)getAdDetails;
- (nullable APSAbstractCreative *)getFirstCreative;
- (nullable APSAbstractCreative *)getCreativeAfter:(APSAbstractCreative *)creative;
- (nullable NSString*)revenueForCreativeAfter:(APSAbstractCreative *)creative;
- (void)resetAdConfiguration:(APSAdConfiguration *)adConfiguration;

@end
NS_ASSUME_NONNULL_END
