/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <UIKit/UIKit.h>

@interface UIView (APSExtensions)

- (void)APSAddFillSuperviewConstraints
    NS_SWIFT_NAME(APSAddFillSuperviewConstraints());

- (void)APSAddConstraintsFromCGRect:(CGRect)rect
    NS_SWIFT_NAME(APSAddConstraintsFromCGRect(_:));

- (void)APSAddCropAndCenterConstraintsWithInitialWidth:(CGFloat)initialWidth initialHeight:(CGFloat)initialHeight
    NS_SWIFT_NAME(APSAddCropAndCenterConstraints(initialWidth:initialHeight:));

- (void)APSAddBottomRightConstraintsWithMarginSize:(CGSize)marginSize;

- (void)APSAddBottomRightConstraintsWithViewSize:(CGSize)viewSize marginSize:(CGSize)marginSize
    NS_SWIFT_NAME(APSAddBottomRightConstraints(viewSize:marginSize:));

- (void)APSAddBottomLeftConstraintsWithViewSize:(CGSize)viewSize marginSize:(CGSize)marginSize
    NS_SWIFT_NAME(APSAddBottomLeftConstraints(viewSize:marginSize:));

- (void)APSAddTopRightConstraintsWithViewSize:(CGSize)viewSize marginSize:(CGSize)marginSize
    NS_SWIFT_NAME(APSAddTopRightConstraints(viewSize:marginSize:));

- (void)APSAddTopLeftConstraintsWithViewSize:(CGSize)viewSize marginSize:(CGSize)marginSize
    NS_SWIFT_NAME(APSAddTopLeftConstraints(viewSize:marginSize:));

- (void)LogViewHierarchy;

- (BOOL)apsIsVisible;

- (BOOL)apsIsVisibleInView:(UIView *)inView;

- (BOOL)apsIsVisibleInViewLegacy:(UIView *)inView;

@end
