/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <UIKit/UIKit.h>

#import "APSPrimaryAdRequesterProtocol.h"

@class APSBidResponse;

NS_ASSUME_NONNULL_BEGIN

@protocol APSInterstitialAd <APSPrimaryAdRequesterProtocol>

@required

/*!
 @abstract Return whether an interstitial is ready for display
 */
@property (nonatomic, readonly) BOOL isReady;

/*!
 @abstract Appstock SDK calls this method to show the interstitial ad from the ad server SDK
 @param controller view controller to be used for presenting the interstitial ad
*/
- (void)showFromViewController:(nullable UIViewController *)controller;

@optional

/*!
  @abstract Called by Appstock SDK to notify primary ad server.
 */
- (void)trackImpression;

@end

NS_ASSUME_NONNULL_END
