/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <UIKit/UIKit.h>

#import "APSModalManagerDelegate.h"
#import "APSModalViewControllerDelegate.h"
#import "APSVoidBlock.h"

@class APSModalState;
@class APSDeferredModalState;
@class APSAbstractCreative;
@class APSModalViewController;
@class APSModalState;

NS_ASSUME_NONNULL_BEGIN

@interface APSModalManager: NSObject <APSModalViewControllerDelegate>

@property (nonatomic, strong, nullable) APSModalViewController *modalViewController;

//The VC class to use to display modals. Defaults is nil.
@property (nullable) Class modalViewControllerClass;

- (instancetype)init;
- (instancetype)initWithDelegate:(nullable id<APSModalManagerDelegate>)delegate NS_DESIGNATED_INITIALIZER;

- (nullable APSVoidBlock)pushModal:(APSModalState *)state
            fromRootViewController:(UIViewController *)fromRootViewController
                          animated:(BOOL)animated
                     shouldReplace:(BOOL)shouldReplace
                 completionHandler:(nullable APSVoidBlock)completionHandler;

- (void)pushDeferredModal:(APSDeferredModalState *)deferredModalState;

- (void)dismissAllInterstitialsIfAny;
- (void)creativeDisplayCompleted:(APSAbstractCreative *)creative;
- (void)forceOrientation:(UIInterfaceOrientation)forcedOrientation NS_SWIFT_NAME(forceOrientation(_:));

- (void)hideModalAnimated:(BOOL)animated completionHandler:(nullable APSVoidBlock)completionHandler;
- (void)backModalAnimated:(BOOL)animated fromRootViewController:(nullable UIViewController *)fromRootViewController completionHandler:(nullable APSVoidBlock)completionHandler;

@end

NS_ASSUME_NONNULL_END
