/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.
 
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
 
  http://www.apache.org/licenses/LICENSE-2.0
 
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <Foundation/Foundation.h>

@class APSBid;
@class APSBidResponse;
@class APSAdUnitConfig;

@protocol APSAdLoaderFlowDelegate;
@protocol APSPrimaryAdRequesterProtocol;

NS_ASSUME_NONNULL_BEGIN

@protocol APSAdLoaderProtocol <NSObject>

@property (nonatomic, weak, nullable) id<APSAdLoaderFlowDelegate> flowDelegate;

@property (nonatomic, readonly) id<APSPrimaryAdRequesterProtocol> primaryAdRequester;

- (void)createAdWithBid:(APSBid *)bid
           adUnitConfig:(APSAdUnitConfig *)adUnitConfig
          adObjectSaver:(void (^)(id))adObjectSaver
      loadMethodInvoker:(void (^)(dispatch_block_t))loadMethodInvoker;

- (void)reportSuccessWithAdObject:(id)adObject
                           adSize:(nullable NSValue *)adSize
                      bidResponse:(nullable APSBidResponse *)bidResponse;

@end

NS_ASSUME_NONNULL_END
