/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

@class APSAbstractCreative;

NS_ASSUME_NONNULL_BEGIN
@protocol APSCreativeViewDelegate <NSObject>
- (void)creativeDidComplete:(APSAbstractCreative *)creative;
- (void)creativeDidDisplay:(APSAbstractCreative *)creative;
- (void)creativeWasClicked:(APSAbstractCreative *)creative;
- (void)creativeViewWasClicked:(APSAbstractCreative *)creative;
- (void)creativeClickthroughDidClose:(APSAbstractCreative *)creative;
- (void)creativeInterstitialDidClose:(APSAbstractCreative *)creative;
- (void)creativeInterstitialDidLeaveApp:(APSAbstractCreative *)creative;
- (void)creativeFullScreenDidFinish:(APSAbstractCreative *)creative;

// Rewarded Ad Only
- (void)creativeDidSendRewardedEvent:(APSAbstractCreative *)creative;

// MRAID Only
- (void)creativeReadyToReimplant:(APSAbstractCreative *)creative;
- (void)creativeMraidDidCollapse:(APSAbstractCreative *)creative;
- (void)creativeMraidDidExpand:(APSAbstractCreative *)creative;

@optional
// Video specific method
- (void)videoCreativeDidComplete:(APSAbstractCreative *)creative;
- (void)videoWasMuted:(APSAbstractCreative *)creative;
- (void)videoWasUnmuted:(APSAbstractCreative *)creative;
@end
NS_ASSUME_NONNULL_END
