/* © 2024 Appstock */

#import <Foundation/Foundation.h>

@class APSLog;

#define APSLogError( s, ... ) [APSLog error:[NSString stringWithFormat:(s), ##__VA_ARGS__] filename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
#define APSLogInfo( s, ... ) [APSLog info:[NSString stringWithFormat:(s), ##__VA_ARGS__] filename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
#define APSLogDebug( s, ... ) [APSLog debug:[NSString stringWithFormat:(s), ##__VA_ARGS__] filename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
#define APSLogVerbose( s, ... ) [APSLog verbose:[NSString stringWithFormat:(s), ##__VA_ARGS__] filename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
#define APSLogWarn( s, ... ) [APSLog warn:[NSString stringWithFormat:(s), ##__VA_ARGS__] filename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
#define APSLogSevere( s, ... ) [APSLog severe:[NSString stringWithFormat:(s), ##__VA_ARGS__] filename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
#define APSLogWhereAmI() [APSLog whereAmIWithFilename:[NSString stringWithUTF8String:__FILE__] line:__LINE__ function:[NSString stringWithUTF8String:__PRETTY_FUNCTION__]];
