/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

#import <UIKit/UIKit.h>
#import "APSConstants.h"
#import "APSVoidBlock.h"

@class APSModalState;
@class APSAdConfiguration;
@class APSInterstitialDisplayProperties;

typedef void (^APSModalStatePopHandler)(APSModalState * _Nullable poppedState);
typedef void (^APSModalStateAppLeavingHandler)(APSModalState * _Nullable leavingState);

@interface APSModalState: NSObject

@property (nonatomic, strong, nullable, readonly) APSAdConfiguration *adConfiguration;
@property (nonatomic, strong, nullable, readonly) APSInterstitialDisplayProperties *displayProperties;
@property (nonatomic, strong, nullable, readonly) UIView *view;

@property (nonatomic, copy, nonnull) APSMRAIDState mraidState;

@property (nonatomic, copy, nullable, readonly) APSModalStatePopHandler onStatePopFinished;
@property (nonatomic, copy, nullable, readonly) APSModalStateAppLeavingHandler onStateHasLeftApp;

// Used to transfer delegate function to another object, rather then current delegate for next states pushed on top
// ref: MOBILE-5849
@property (nonatomic, copy, nullable, readonly) APSModalStatePopHandler nextOnStatePopFinished;
@property (nonatomic, copy, nullable, readonly) APSModalStateAppLeavingHandler nextOnStateHasLeftApp;

@property (nonatomic, strong, nullable) APSVoidBlock onModalPushedBlock;

@property (nonatomic, assign, readonly, getter=isRotationEnabled) BOOL rotationEnabled;

- (nonnull instancetype)init NS_UNAVAILABLE;

+ (nonnull instancetype)modalStateWithView:(nonnull UIView *)view
                           adConfiguration:(nullable APSAdConfiguration *)adConfiguration
                         displayProperties:(nullable APSInterstitialDisplayProperties *)displayProperties
                        onStatePopFinished:(nullable APSModalStatePopHandler)onStatePopFinished
                         onStateHasLeftApp:(nullable APSModalStateAppLeavingHandler)onStateHasLeftApp;


+ (nonnull instancetype)modalStateWithView:(nonnull UIView *)view
                           adConfiguration:(nullable APSAdConfiguration *)adConfiguration
                         displayProperties:(nullable APSInterstitialDisplayProperties *)displayProperties
                        onStatePopFinished:(nullable APSModalStatePopHandler)onStatePopFinished
                         onStateHasLeftApp:(nullable APSModalStateAppLeavingHandler)onStateHasLeftApp
                    nextOnStatePopFinished:(nullable APSModalStatePopHandler)nextOnStatePopFinished
                     nextOnStateHasLeftApp:(nullable APSModalStateAppLeavingHandler)nextOnStateHasLeftApp;


+ (nonnull instancetype)modalStateWithView:(nonnull UIView *)view
                           adConfiguration:(nullable APSAdConfiguration *)adConfiguration
                         displayProperties:(nullable APSInterstitialDisplayProperties *)displayProperties
                        onStatePopFinished:(nullable APSModalStatePopHandler)onStatePopFinished
                         onStateHasLeftApp:(nullable APSModalStateAppLeavingHandler)onStateHasLeftApp
                        onModalPushedBlock:(nullable APSVoidBlock)onModalPushedBlock;

+ (nonnull instancetype)modalStateWithView:(nonnull UIView *)view
                           adConfiguration:(nullable APSAdConfiguration *)adConfiguration
                         displayProperties:(nullable APSInterstitialDisplayProperties *)displayProperties
                        onStatePopFinished:(nullable APSModalStatePopHandler)onStatePopFinished
                         onStateHasLeftApp:(nullable APSModalStateAppLeavingHandler)onStateHasLeftApp
                    nextOnStatePopFinished:(nullable APSModalStatePopHandler)nextOnStatePopFinished
                     nextOnStateHasLeftApp:(nullable APSModalStateAppLeavingHandler)nextOnStateHasLeftApp
                        onModalPushedBlock:(nullable APSVoidBlock)onModalPushedBlock;

@end
