/* © 2024 Appstock */

#import "APSORTBAbstract.h"
#import "APSORTBAbstract+Protected.h"

@class APSORTBBidExtRewardedReward;
@class APSORTBBidExtRewardedCompletion;
@class APSORTBBidExtRewardedClose;

NS_ASSUME_NONNULL_BEGIN

@interface APSORTBBidExtRewarded : APSORTBAbstract

/// Metadata provided by the publisher on the ad platform to describe the reward.
@property (nonatomic, strong, nullable) APSORTBBidExtRewardedReward * reward;

/// Describes the condition when the SDK should send a signal to the application that the user has earned the reward.
@property (nonatomic, strong, nullable) APSORTBBidExtRewardedCompletion * completion;

/// Describes the close behavior. How should the SDK manage the ad when it is encountered as viewed.
@property (nonatomic, strong, nullable) APSORTBBidExtRewardedClose * close;

@end

NS_ASSUME_NONNULL_END
