/* © 2024 Appstock */

/*   Copyright 2018-2021 Prebid.org, Inc.

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 CHANGE NOTICE: The file content was modified to rebrand the work, adapt the product for the new use case, and change the distribution license.
 The patch to the original code is available in the Appstock repository.
 All changes after applying the patch are made under the new license and copyrights mentioned at the beginning of this file.
*/

@import Foundation;

#import "APSErrorCode.h"
#import "APSErrorType.h"

NS_ASSUME_NONNULL_BEGIN

@interface AppstockError: NSError

- (instancetype)init: (NSString*)message NS_SWIFT_NAME(init(message:));

// MARK: - Setup errors
@property (nonatomic, copy, nullable) NSString* message;

@property (nonatomic, class, readonly) NSError *requestInProgress;

// MARK: - Known server text errors

@property (nonatomic, class, readonly) NSError *idsNotSet;
@property (nonatomic, class, readonly) NSError *idsConflict;
@property (nonatomic, class, readonly) NSError *invalidSize;

// MARK: - Unknown server text errors

+ (NSError *)serverError:(NSString *)errorBody;

// MARK: - Response processing errors

@property (nonatomic, class, readonly) NSError *jsonDictNotFound;
@property (nonatomic, class, readonly) NSError *responseDeserializationFailed;
@property (nonatomic, class, readonly) NSError *blankResponse;

// MARK: - Integration layer errors
@property (nonatomic, class, readonly) NSError *noWinningBid;
@property (nonatomic, class, readonly) NSError *noVastTagInMediaData;
@property (nonatomic, class, readonly) NSError *wrongFormatInResponse;

+ (AppstockError *)errorWithDescription:(NSString *)description NS_SWIFT_NAME(error(description:));
+ (AppstockError *)errorWithDescription:(NSString *)description statusCode:(APSErrorCode)code NS_SWIFT_NAME(error(description:statusCode:));
+ (AppstockError *)errorWithMessage:(NSString *)message type:(APSErrorType)type NS_SWIFT_NAME(error(message:type:));

+ (BOOL)createError:(NSError* _Nullable __autoreleasing * _Nullable)error description:(NSString *)description;
+ (BOOL)createError:(NSError* _Nullable __autoreleasing * _Nullable)error description:(NSString *)description statusCode:(APSErrorCode)code;
+ (BOOL)createError:(NSError* _Nullable __autoreleasing * _Nullable)error message:(NSString *)message type:(APSErrorType)type;


@end

NS_ASSUME_NONNULL_END
